#ifndef STACK_CONST_H 
#define global STACK_CONST_H
#define STACK_MEMBERS 			1024
#define HEAP_MEMBERS 			1024
#define MAX_LABELS 				200
#define MAX_LABEL_LENGTH 		500
#define MAX_INSTRUCTIONS 		40
#define MAX_INSTRUCTION_LENGTH 	32
#define MAX_NESTED_SUBROUTINES	32
#endif

#module mod_value_token obj_token_ID, obj_exist,  obj_value, obj_value_2nd, obj_value_type//, obj_line_num, obj_command_num
// obj_Token_ID : TokenID
// obj_exist    : Token݂邩 :1 ݂Ȃ:0-1
// obj_value    : Token̒l
// obj_value_2nd  : Token̒l 2
// obj_value_type : Tokenvaluẽ^Cv
// ^CvȂ:0 ߌ^:1 ^:2 ^:3 ^:4 bool^:5 LINE_NUM^:6 COMMAND_NUM^:7
#const global OBJ_TYPE_NULL 0
#const global OBJ_TYPE_INSN 1
#const global OBJ_TYPE_STR  2
#const global OBJ_TYPE_DBL  3
#const global OBJ_TYPE_INT  4
#const global OBJ_TYPE_BOOL 5
#const global OBJ_TYPE_LINE_NUM 6
#const global OBJ_TYPE_COM_NUM  7
#modinit int p_ID
	obj_token_ID = p_ID
	obj_exist = -1
	obj_value = 0
	obj_value_type = 0
	return
#modfunc init_value_token_ID int p_ID, var p_value
	if obj_token_ID == p_ID{
		obj_exist = 1
		obj_value = p_value
		obj_value_type = vartype(p_value)
		return
	}
	dialog "init_value_token_ID̃G[FIDႢ܂ : " + obj_token_ID + " : " + p_ID,1
	return
#modfunc init_value_token var p_value
	obj_exist = 1
	obj_value = p_value
	obj_value_type = vartype(p_value)
	return
#modfunc del_value_token_ID int p_ID
	if obj_token_ID == p_ID{
		obj_exist = -1
		obj_value = 0
		obj_value_type = 0
		return
	}
	dialog "del_value_token_ID̃G[FIDႢ܂ : " + obj_token_ID + " : " + p_ID,1
	return
#modfunc del_value_token
	obj_exist = -1
	obj_value = 0
	obj_value_type = 0
	return
#modfunc set_obj_value_token var p_value
	obj_value  = p_value
	obj_value_type = vartype(p_value)
	return
#modfunc set_obj_value_token_2nd var p_value
	obj_value_2nd  = p_value
	return
#modfunc set_obj_insn int p_insn
	obj_value  = p_insn
	obj_value_type = OBJ_TYPE_INSN
	return
#modfunc set_obj_bool int p_bool
	if p_bool == 0{
		obj_value  = 0
	} else {
		obj_value  = 1
	}
	obj_value_type = OBJ_TYPE_BOOL
	return
#modfunc set_obj_line_num int p_line
	obj_value  = p_line
	obj_value_type = OBJ_TYPE_LINE_NUM
	return
#modfunc set_obj_command_num int p_com
	obj_value  = p_com
	obj_value_type = OBJ_TYPE_COM_NUM
	return
#modcfunc get_obj_token_ID_value_token 
	return obj_token_ID
#modcfunc get_obj_exist_value_token 
	return obj_exist
#modcfunc get_obj_value_token 
	return obj_value
#modcfunc get_obj_2nd_value_token 
	return obj_value_2nd
#modcfunc get_obj_type_value_token 
	return obj_value_type
#global

#module mod_value_token_stack
#deffunc init_value_token_stack
	stack_size = 1024
	stack_current = 0
	repeat 1028
		newmod obj_value_token_stack,mod_value_token,cnt
	loop
	return
#deffunc stack_push var p4push
	if stack_current < STACK_MEMBERS@ {
		init_value_token obj_value_token_stack.stack_current,p4push
		stack_current++
		return 1
	}
	return 0
#deffunc stack_pop var r4pop,var r4pop_type
	if stack_current >= 1 {
		stack_current--
		r4pop = get_obj_value_token(obj_value_token_stack.stack_current)
		r4pop_type = get_obj_type_value_token(obj_value_token_stack.stack_current)
		del_value_token obj_value_token_stack.stack_current
		return 1
	}
	return 0
#deffunc stack_peak int p_depth,var r4pop,var r4pop_type
	tmp4peak = stack_current - p_depth - 1
	if tmp4peak >= 0 {
		r4pop = get_obj_value_token(obj_value_token_stack.tmp4peak)
		r4pop_type = get_obj_type_value_token(obj_value_token_stack.tmp4peak)
		return 1
	}
	return 0
#defcfunc stack_dump
	sdim var4stack_dump,2048
	var4stack_dump = "ID : exist : type : value\n"
	tmp_i = (stack_current/8+1)*8
	repeat tmp_i
	var4stack_dump += get_obj_token_ID_value_token(obj_value_token_stack.cnt)
	var4stack_dump += " : " + get_obj_exist_value_token(obj_value_token_stack.cnt)
	var4stack_dump += " : " + get_obj_type_value_token(obj_value_token_stack.cnt)
	if get_obj_type_value_token(obj_value_token_stack.cnt) == 2{
		var4stack_dump += " str"
	}
	if get_obj_type_value_token(obj_value_token_stack.cnt) == 3{
		var4stack_dump += " dbl"
	}
	if get_obj_type_value_token(obj_value_token_stack.cnt) == 4{
		var4stack_dump += " int"
	}
	var4stack_dump += " : " + get_obj_value_token(obj_value_token_stack.cnt) + "\n"
	loop
	return var4stack_dump
#deffunc stack_push_pai local loc_p_dbl
	loc_p_dbl = 3.14159265358900
	if stack_current < STACK_MEMBERS@ {
		init_value_token obj_value_token_stack.stack_current,loc_p_dbl
		stack_current++
		return 1
	}
	return 0
#deffunc stack_push_root2 local loc_p_dbl
	loc_p_dbl = 1.41421356
	if stack_current < STACK_MEMBERS@ {
		init_value_token obj_value_token_stack.stack_current,loc_p_dbl
		stack_current++
		return 1
	}
	return 0
#deffunc stack_push_root3 local loc_p_dbl
	loc_p_dbl = 1.7320508
	if stack_current < STACK_MEMBERS@ {
		init_value_token obj_value_token_stack.stack_current,loc_p_dbl
		stack_current++
		return 1
	}
	return 0
#deffunc stack_push_root5 local loc_p_dbl
	loc_p_dbl = 2.2360679
	if stack_current < STACK_MEMBERS@ {
		init_value_token obj_value_token_stack.stack_current,loc_p_dbl
		stack_current++
		return 1
	}
	return 0
#deffunc stack_push_root6 local loc_p_dbl
	loc_p_dbl = 2.44949
	if stack_current < STACK_MEMBERS@ {
		init_value_token obj_value_token_stack.stack_current,loc_p_dbl
		stack_current++
		return 1
	}
	return 0
#deffunc stack_push_root7 local loc_p_dbl
	loc_p_dbl = 2.64575
	if stack_current < STACK_MEMBERS@ {
		init_value_token obj_value_token_stack.stack_current,loc_p_dbl
		stack_current++
		return 1
	}
	return 0
#deffunc stack_push_root8 local loc_p_dbl
	loc_p_dbl = 2.828427
	if stack_current < STACK_MEMBERS@ {
		init_value_token obj_value_token_stack.stack_current,loc_p_dbl
		stack_current++
		return 1
	}
	return 0
#deffunc stack_push_root10 local loc_p_dbl
	loc_p_dbl = 3.1622
	if stack_current < STACK_MEMBERS@ {
		init_value_token obj_value_token_stack.stack_current,loc_p_dbl
		stack_current++
		return 1
	}
	return 0
#deffunc stack_push_e local loc_p_dbl
	loc_p_dbl = 2.71828182845900
	if stack_current < STACK_MEMBERS@ {
		init_value_token obj_value_token_stack.stack_current,loc_p_dbl
		stack_current++
		return 1
	}
	return 0
#global
#if 1
init_value_token_stack
tmp=123
stack_push tmp
logmes "ret" + stat
tmp=123.12
stack_push tmp
logmes "ret" + stat
tmp_val = 0
tmp_type = 0
stack_pop tmp_val,tmp_type
logmes "ret" + stat
logmes tmp_val
logmes tmp_type
tmp_val = 0
tmp_type = 0
stack_pop tmp_val,tmp_type
logmes "ret" + stat
logmes tmp_val
logmes tmp_type
tmp_val = 0
tmp_type = 0
stack_pop tmp_val,tmp_type
logmes "ret" + stat
logmes tmp_val
logmes tmp_type
tmp=456
stack_push tmp
tmp=456.78
stack_push tmp
tmp="abc"
stack_push tmp
tmp_val = 0
tmp_type = 0
stack_peak 0,tmp_val,tmp_type
logmes "ret" + stat
logmes tmp_val
logmes tmp_type
tmp_val = 0
tmp_type = 0
stack_peak 1,tmp_val,tmp_type
logmes "ret" + stat
logmes tmp_val
logmes tmp_type
tmp_val = 0
tmp_type = 0
stack_peak 2,tmp_val,tmp_type
logmes "ret" + stat
logmes tmp_val
logmes tmp_type
tmp_val = 0
tmp_type = 0
stack_pop tmp_val,tmp_type
logmes "ret" + stat
logmes tmp_val
logmes tmp_type
tmp_val = 0
tmp_type = 0
stack_peak 0,tmp_val,tmp_type
logmes "ret" + stat
logmes tmp_val
logmes tmp_type
tmp_val = 0
tmp_type = 0
stack_peak -1,tmp_val,tmp_type
logmes "ret" + stat
logmes tmp_val
logmes tmp_type
tmp=3.141592
stack_push tmp
tmp=1.414213
stack_push tmp
tmp=1.732050
stack_push tmp
tmp=2.236067
stack_push tmp
tmp="abc"
stack_push tmp
tmp="def"
stack_push tmp
mes stack_dump()
stack_push_pai
mes stack_dump()
#endif
#if 1
init_value_token_stack
stack_push_pai
stack_push_root2
stack_push_root3
stack_push_root5
stack_push_root6
stack_push_root7
stack_push_root8
stack_push_root10
stack_push_e
mes stack_dump()
#endif
