#ifndef _MY_SCRAMBLER_AS_
#define _MY_SCRAMBLER_AS_

#module myScrambler
dim seed, 4
password__ = "pass"

#deffunc myScrambler_SetPassword str password
	password__@myScrambler = password
	return

#deffunc myScrambler_Init str keyword, int size
	seed( 0 ) = 0xD9363228
	seed( 1 ) = 0x021A79C9
	seed( 2 ) = 0x7604820B
	seed( 3 ) = 0xD18E1939

	para_a = 0xE54352FA;
	para_b = 0x082D376F;
	para_c = 0xE673CB52;
	value = 1;
	key = 0
	kw_copy = keyword

	repeat 128
		key = peek( kw_copy, cnt )
		value = para_a * value * key + para_b;
		if( value & 1 ){
			value = 0x80000000 | ( ( value >> 1 ) & 0x7FFFFFFF );
		}
		else{
			value = ( ( value >> 1 ) & 0x7FFFFFFF );
		}
		value ^= para_c
		seed( 0 ) = int( value ^ seed( 0 ) );
		seed( 1 ) = int( value ^ seed( 1 ) );
		seed( 2 ) = int( value ^ seed( 2 ) );
		seed( 3 ) = int( value ^ seed( 3 ) );

;logmes "" + seed( 0 ) + "," + seed( 1 ) + "," + seed( 2 ) + "," + seed( 3 )
		if( cnt >= 128 - 1 || cnt >= size - 1 ){
			break
		}
	loop
logmes "" + strf( "%x", seed( 0 ) ) + "," + strf( "%x", seed( 1 ) ) + "," + strf( "%x", seed( 2 ) )

	return

#deffunc myScrambler_XorShift var ret_value
	t = seed( 0 ) ^ ( seed( 0 ) << 11 )
	seed( 0 ) = seed( 1 )
	seed( 1 ) = seed( 2 )
	seed( 2 ) = seed( 3 )
	seed( 3 ) = ( seed( 3 ) ^ ( seed( 3 ) >> 19 ) ) ^ ( t ^ ( t >> 8 ) )
	ret_value = seed( 3 )
	return

#deffunc myScrambler_Encode array ary_src, array ary_dst, int size
	ret_value = 0
	key_old = 0
logmes "pw:" + password__@myScrambler
	myScrambler_Init password__@myScrambler, strlen( password__@myScrambler )
	repeat size
		myScrambler_XorShift ret_value
		key_old = peek( ary_src, cnt * 4 )
;ret_value = cnt
		key = ( key_old ^ ret_value ) & 0xFF
;logmes "" + key_old + " -> " + key
		poke ary_dst, cnt, key
	loop
	return

#deffunc myScrambler_Decode array ary_src, array ary_dst, int size
	ret_value = 0
	key_old = 0
logmes "pw:" + password__@myScrambler
	myScrambler_Init password__@myScrambler, strlen( password__@myScrambler )
	repeat size
		myScrambler_XorShift ret_value
		key_old = peek( ary_src, cnt )
;ret_value = cnt
		key = ( key_old ^ ret_value ) & 0xFF
;logmes "" + ( ret_value & 0xFF )
;logmes "" + key_old + " -> " + key
		poke ary_dst, cnt, key
	loop
	return

#global

#endif
